from typing import Tuple, List


def map_parser(path_like) -> Tuple[List[Tuple[int, int]], int, List[int], List[int]]:
    grid_posns = []
    start_idx = []
    end_idx = []

    with open(path_like, "r") as map_file:
        file_text = map_file.read()
        (agent_spec, map_spec) = file_text.split("---\n")

        space_map = {}

        for row_num, line in enumerate(map_spec.strip().split("\n")):
            for col_num, char in enumerate(line.strip().split()):
                if char == "0":
                    grid_posns.append((col_num, row_num))  # This grid position is in-bounds
                elif char == "1":
                    continue  # Out of bounds
                else:
                    # In bounds, and is "special"
                    space_map[char] = len(grid_posns)  # Record the idx of the character
                    grid_posns.append((col_num, row_num))

        for agent_info in agent_spec.strip().split("\n"):
            [start_space, end_space] = agent_info.strip().split()
            start_idx.append(space_map[start_space])
            end_idx.append(space_map[end_space])

    return grid_posns, len(start_idx), start_idx, end_idx


def add_posn(ab, cd):
    a, b = ab
    c, d = cd
    return (a + c, b + d)
